//	COffscreen.h

#ifndef _H_COffscreen
#define _H_COffscreen

#include "offscreen_manager.h"

typedef enum {
	OffscreenCB_NONE, 

	OffscreenCB_GET_FRAME, 
	OffscreenCB_GET_FRAME_DEPTH, 
	OffscreenCB_CAUSE_UPDATE, 

	OffscreenCB_NUMTYPES
} OffscreenCBType;

typedef union {
	Rect	frame;
	short	frame_depth;
} OffscreenCBData;

typedef void	(*OffscreenCB)(
	OffscreenCBType cbType, 
	OffscreenCBData	*cbData, 
	void			*cbRefcon
);

class	COffscreen;

COffscreen	*GetNewCOffscreen(
	GrafPtr			port, 
	short			maxDepth, 
	OffscreenCB		offscreenCB, 
	void			*cbRefcon);

COffscreen	*GetNewCOffscreenFromPictFile(
	FSSpec			*pictFileP, 
	Rect			*origR, 
	GrafPtr			port, 
	short			maxDepth, 
	OffscreenCB		offscreenCB, 
	void			*cbRefcon);

class	COffscreen {
	
	public:		void	IOffscreen(
					GrafPtr			port, 
					short			maxDepth, 
					OffscreenCB		offscreenCB, 
					void			*cbRefcon
				);
	
	virtual		void	Dispose(void);
				
				void	SetMaxDepth(short maxDepth);
				
				void	Use(void);
				void	StopUsing(void);
				void	Blit(void);
				void	BlitRect(Rect *theRect);
				void	StretchBlit(Rect *dstR);
				Rect	GetFrame(void);
	
				void	Callback(
					OffscreenCBType cbType, 
					void			*cbData);

				void	MakeOffscreen(void);
				short	GetDepth(void);
				
				BitMap	*GetPix(GrafPtr pix);
				void	ReleasePix(GrafPtr pix);

				void	RestoreDest(void);
				void	SetDest(COffscreen *offsP);
				void	UpdateDest(GrafPtr destP, Boolean isOffsB);

	/******************/
	private:	GrafPtr			i_dest;
				OffscreenCB		i_offscreenCB;
				void			*i_cbRefcon;
				short			i_maxDepth;
				PortAndDevice	i_savePD;
				GWorldFlags		i_pixState;
				
				Boolean			i_saved_prevB;
				GrafPtr			i_prev_dest;
				Boolean			i_prev_dest_is_offs;
	
	public:		Boolean			i_invalid;
				Boolean			i_using;
				Boolean			i_destIsOffscreen;
				GWorldPtr		i_offscreen;
};

#endif